/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.LegendaryVillainMaker;

import LegendaryCardMaker.CardMaker;
import LegendaryCardMaker.Icon;
import LegendaryCardMaker.LegendaryCardMaker;
import LegendaryCardMaker.LegendaryCardMakerFrame;
import LegendaryCardMaker.LegendaryVillainMaker.GaussianFilter;
import LegendaryCardMaker.LegendaryVillainMaker.VillainCard;
import LegendaryCardMaker.LegendaryVillainMaker.VillainCardType;
import LegendaryCardMaker.WordDefinition;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class VillainMaker
extends CardMaker {
    public String exportFolder = "cardCreator";
    String templateFolder = "legendary" + File.separator + "templates" + File.separator + LegendaryCardMaker.expansionStyle;
    private Locale currentLocale = Locale.getDefault();
    private ResourceBundle CardText = ResourceBundle.getBundle("LegendaryCardMaker.tools.language.LegendaryCardMakerCardText", this.currentLocale);
    int cardWidth = 750;
    int cardHeight = 1050;
    int dpi = 300;
    boolean exportImage = false;
    public boolean exportToPNG = true;
    int teamIconX = 700;
    int teamIconY = 785;
    int teamMaxWidth = 48;
    int teamMaxHeight = 48;
    boolean includeBlurredBGTeam = true;
    int expandTeam = 1;
    int teamBlurRadius = 5;
    boolean teamBlurDouble = true;
    int powerIconX = 54;
    int powerIconY = 120;
    int powerMaxWidth = 54;
    int powerMaxHeight = 54;
    boolean includeBlurredBGPower = true;
    int expandPower = 1;
    int powerBlurRadius = 5;
    boolean powerBlurDouble = true;
    public int cardNameSize = 40;
    int cardNameMinSize = 30;
    int cardNameY = 55;
    Color cardNameColor = new Color(255, 186, 20);
    boolean includeBlurredBGName = true;
    int expandCardName = 2;
    int cardNameBlurRadius = 5;
    boolean cardNameBlurDouble = true;
    public int villainGroupSize = 33;
    int villainGroupMinSize = 30;
    int villainGroupY = 90;
    Color villainGroupColor = new Color(255, 186, 20);
    boolean includeBlurredBGvillainGroup = true;
    int expandvillainGroup = 2;
    int villainGroupBlurRadius = 5;
    boolean villainGroupBlurDouble = true;
    int costSize = 120;
    int costX = 635;
    int costY = 993;
    Color costColor = Color.WHITE;
    boolean includeBlurredBGCost = true;
    int expandCost = 5;
    int costBlurRadius = 5;
    boolean costBlurDouble = false;
    int vpSize = 38;
    int vpX = 638;
    int vpY = 795;
    Color vpColor = Color.WHITE;
    boolean includeBlurredBGVP = true;
    int expandVp = 2;
    int vpBlurRadius = 2;
    boolean vpBlurDouble = false;
    int attackSize = 120;
    int attackX = 650;
    int attackY = 990;
    Color attackColor = Color.WHITE;
    boolean includeBlurredBGAttack = true;
    int expandAttack = 5;
    int attackBlurRadius = 5;
    boolean attackBlurDouble = false;
    HashMap<String, Integer> costOffsets = new HashMap();
    public int textSize = 27;
    int textX = 154;
    int textY = 805;
    Color textColor = Color.BLACK;
    boolean includeBlurredBGText = false;
    int expandText = 0;
    int textBlurRadius = 0;
    boolean textBlurDouble = false;
    double textIconHeight = 1.2;
    double textGapHeight = 0.6;
    double textDefaultGapHeight = 0.2;
    int expandTextIcon = 0;
    int textIconBlurRadius = 5;
    boolean textIconBlurDouble = true;
    double rarePaddingRatio = 0.06;
    int rareBlurRadius = 25;
    public int textStartOffset = 0;
    public double yOffsetRatio = 0.1;
    public VillainCard card;
    public BufferedWriter bwErr = null;

    public VillainMaker() {
        this.costOffsets.put("4", -8);
        this.costOffsets.put("6", -5);
    }

    public void setCard(VillainCard c) {
        this.card = c;
        if (this.card.numberInDeck <= 0 && this.card.cardType != null) {
            this.card.numberInDeck = this.card.cardType.getCount();
        }
        if (this.card.nameSize > 0) {
            this.cardNameSize = this.card.nameSize;
        }
        if (this.card.abilityTextSize > 0) {
            this.textSize = this.card.abilityTextSize;
        }
    }

    public void populateVillainCard() {
        this.card = new VillainCard();
        this.card.villainGroup = "Swoop";
        this.card.name = "The Friendly One";
        this.card.cardType = VillainCardType.VILLAIN;
        this.card.cardTeam = Icon.valueOf("AUTOBOT");
        this.card.attack = "2";
        this.card.victory = "3";
        this.card.abilityText = "<k>Transform <g> <r>Select a player. That player must play an <AUTOBOT> hero from their hand or discard pile that has a <COST> of 5 or less. You gain all effects of that card as if you played it. That player discards the card after this turn.";
    }

    public static VillainCard getBlankVillainCard() {
        VillainCard card = new VillainCard();
        card.villainGroup = "";
        card.name = "";
        card.cardType = VillainCardType.VILLAIN;
        card.cardTeam = Icon.valueOf("NONE");
        card.abilityText = "card text";
        return card;
    }

    @Override
    public BufferedImage generateCard() {
        int stringLength;
        Font font;
        int x;
        int stringLength2;
        FontMetrics metrics;
        Graphics2D g2;
        BufferedImage bi;
        ImageIcon ii;
        BufferedImage bi2;
        boolean timeCount = false;
        int type = 2;
        if (this.exportToPNG) {
            type = 2;
        }
        BufferedImage image = new BufferedImage(this.cardWidth, this.cardHeight, type);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g = this.setGraphicsHints(g);
        if (this.card.imagePath != null) {
            String imagePath = this.card.imagePath;
            if (!imagePath.contains(File.separator) && LegendaryCardMakerFrame.lcmf.lcm.currentFile != null) {
                imagePath = String.valueOf(new File(LegendaryCardMakerFrame.lcmf.lcm.currentFile).getParent()) + File.separator + this.card.imagePath;
            }
            bi2 = this.resizeImage(new ImageIcon(imagePath), this.card.imageZoom);
            g.drawImage((Image)bi2, this.card.imageOffsetX, this.card.imageOffsetY, null);
        }
        if (this.card.cardType != null && this.card.cardType.equals((Object)VillainCardType.VILLAIN)) {
            ii = new ImageIcon(String.valueOf(this.templateFolder) + File.separator + "villain_normal" + File.separator + "back_underlay.png");
            g.drawImage((Image)this.resizeImage(ii, this.cardWidth, this.cardHeight), 0, 0, null);
        }
        if (this.card.cardType != null && this.card.cardType.equals((Object)VillainCardType.HENCHMEN)) {
            ii = new ImageIcon(String.valueOf(this.templateFolder) + File.separator + "villain_henchmen" + File.separator + "back_underlay.png");
            g.drawImage((Image)this.resizeImage(ii, this.cardWidth, this.cardHeight), 0, 0, null);
        }
        if (this.card.cardType != null) {
            this.card.cardType.equals((Object)VillainCardType.MASTERMIND);
        }
        if (this.card.cardType != null && this.card.cardType.equals((Object)VillainCardType.BYSTANDER)) {
            ii = new ImageIcon(String.valueOf(this.templateFolder) + File.separator + "bystander" + File.separator + "back_underlay.png");
            g.drawImage((Image)this.resizeImage(ii, this.cardWidth, this.cardHeight), 0, 0, null);
        }
        if (this.card.cardType != null && this.card.cardType.equals((Object)VillainCardType.WOUND)) {
            ii = new ImageIcon(String.valueOf(this.templateFolder) + File.separator + "wound" + File.separator + "back_underlay.png");
            g.drawImage((Image)this.resizeImage(ii, this.cardWidth, this.cardHeight), 0, 0, null);
        }
        if (this.card.cardType != null && this.card.cardType.equals((Object)VillainCardType.BINDINGS)) {
            ii = new ImageIcon(String.valueOf(this.templateFolder) + File.separator + "bindings" + File.separator + "back_underlay.png");
            g.drawImage((Image)this.resizeImage(ii, this.cardWidth, this.cardHeight), 0, 0, null);
        }
        if (this.card.cardTeam != null && this.card.cardTeam.getImagePath() != null) {
            this.teamIconX = 700;
            this.teamIconY = 785;
            if (this.card.cardType != null && this.card.cardType.equals((Object)VillainCardType.HENCHMEN)) {
                this.teamIconX += 17;
                this.teamIconY -= 90;
            } else if (this.card.cardType != null && this.card.cardType.equals((Object)VillainCardType.BYSTANDER)) {
                this.teamIconX += 17;
                this.teamIconY -= 25;
            }
            bi = this.getIcon(this.card.cardTeam, this.teamMaxWidth, this.teamMaxHeight);
            int x2 = this.teamIconX - bi.getWidth() / 2;
            int y = this.teamIconY - bi.getWidth() / 2;
            if (this.includeBlurredBGTeam) {
                this.drawUnderlay(bi, g, type, x2, y, this.teamBlurRadius, this.teamBlurDouble, this.expandTeam);
            }
            g.drawImage((Image)bi, x2, y, null);
        }
        if (this.card.name != null) {
            bi = new BufferedImage(this.cardWidth, this.cardHeight, 2);
            g2 = this.getGraphics(bi);
            g2.setColor(this.cardNameColor);
            if (this.card.cardType != null && this.card.cardType.equals((Object)VillainCardType.BYSTANDER)) {
                g2.setColor(Color.WHITE);
            }
            if (this.card.cardType != null && this.card.cardType.equals((Object)VillainCardType.WOUND)) {
                g2.setColor(Color.WHITE);
            }
            if (this.card.cardType != null && this.card.cardType.equals((Object)VillainCardType.BINDINGS)) {
                g2.setColor(Color.WHITE);
            }
            Font font2 = null;
            try {
                font2 = Font.createFont(0, new File("Percolator.otf"));
                font2 = font2.deriveFont((float)this.cardNameSize);
                g2.setFont(font2);
            }
            catch (Exception e) {
                e.printStackTrace();
                font2 = new Font("Percolator", 0, this.cardNameSize);
                g2.setFont(font2);
            }
            g2.setFont(font2);
            metrics = g2.getFontMetrics(font2);
            stringLength2 = SwingUtilities.computeStringWidth(metrics, this.card.name.toUpperCase());
            x = this.cardWidth / 2 - stringLength2 / 2;
            g2 = this.setGraphicsHints(g2);
            g2.drawString(this.card.name.toUpperCase(), x, this.cardNameY);
            if (this.includeBlurredBGName) {
                this.drawUnderlay(bi, g2, type, 0, 0, this.cardNameBlurRadius, this.cardNameBlurDouble, this.expandCardName);
            }
            g2.drawString(this.card.name.toUpperCase(), x, this.cardNameY);
            g.drawImage((Image)bi, 0, 0, null);
            g2.dispose();
        }
        if (this.card.villainGroup != null) {
            String villainGroup = this.card.villainGroup;
            if (this.card.cardType != null && this.card.cardType.equals((Object)VillainCardType.VILLAIN)) {
                villainGroup = this.CardText.getString("Villain");
                villainGroup = String.valueOf(villainGroup) + " - " + villainGroup;
                villainGroup = villainGroup.toUpperCase();
            }
            if (this.card.cardType != null && this.card.cardType.equals((Object)VillainCardType.HENCHMEN)) {
                villainGroup = this.CardText.getString("HenchmanVillain");
                villainGroup = villainGroup.toUpperCase();
            }
            if (this.card.cardType != null && this.card.cardType.equals((Object)VillainCardType.MASTERMIND)) {
                villainGroup = this.CardText.getString("Mastermind");
                villainGroup = villainGroup.toUpperCase();
            }
            if (this.card.cardType != null && this.card.cardType.equals((Object)VillainCardType.MASTERMIND_TACTIC)) {
                villainGroup = this.CardText.getString("MastermindTactic");
                villainGroup = String.valueOf(villainGroup) + " - " + villainGroup;
                villainGroup = villainGroup.toUpperCase();
            }
            if (this.card.cardType != null && this.card.cardType.equals((Object)VillainCardType.BYSTANDER)) {
                villainGroup = null;
            }
            if (this.card.cardType != null && this.card.cardType.equals((Object)VillainCardType.WOUND)) {
                villainGroup = null;
            }
            if (this.card.cardType != null && this.card.cardType.equals((Object)VillainCardType.BINDINGS)) {
                villainGroup = null;
            }
            if (villainGroup != null) {
                bi2 = new BufferedImage(this.cardWidth, this.cardHeight, 2);
                Graphics2D g22 = this.getGraphics(bi2);
                g22.setColor(this.villainGroupColor);
                font = null;
                try {
                    font = Font.createFont(0, new File("Percolator.otf"));
                    font = font.deriveFont((float)this.villainGroupSize);
                    g22.setFont(font);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    font = new Font("Percolator", 0, this.villainGroupSize);
                    g22.setFont(font);
                }
                g22.setFont(font);
                FontMetrics metrics2 = g22.getFontMetrics(font);
                stringLength = SwingUtilities.computeStringWidth(metrics2, villainGroup);
                int x3 = this.cardWidth / 2 - stringLength / 2;
                g22 = this.setGraphicsHints(g22);
                g22.drawString(villainGroup, x3, this.villainGroupY);
                if (this.includeBlurredBGvillainGroup) {
                    this.drawUnderlay(bi2, g22, type, 0, 0, this.villainGroupBlurRadius, this.villainGroupBlurDouble, this.expandvillainGroup);
                }
                g22.drawString(villainGroup, x3, this.villainGroupY);
                g.drawImage((Image)bi2, 0, 0, null);
                g22.dispose();
            }
        }
        if (this.card.victory != null) {
            this.vpX = 638;
            this.vpY = 795;
            if (this.card.cardType != null && this.card.cardType.equals((Object)VillainCardType.HENCHMEN)) {
                this.vpX += 23;
                this.vpY -= 87;
            } else if (this.card.cardType != null && this.card.cardType.equals((Object)VillainCardType.BYSTANDER)) {
                this.vpX += 25;
                this.vpY -= 21;
            } else {
                ii = new ImageIcon(String.valueOf(this.templateFolder) + File.separator + "villain_normal" + File.separator + "attr_vp.png");
                g.drawImage((Image)this.resizeImage(ii, this.cardWidth, this.cardHeight), 0, 0, null);
            }
            bi = new BufferedImage(this.cardWidth, this.cardHeight, 2);
            g2 = this.getGraphics(bi);
            g2.setColor(this.vpColor);
            Font font3 = null;
            try {
                font3 = Font.createFont(0, new File("Sylfaen.ttf"));
                font3 = font3.deriveFont((float)this.vpSize);
            }
            catch (Exception e) {
                e.printStackTrace();
                font3 = new Font("Sylfaen", 0, this.vpSize);
            }
            g2.setFont(font3);
            metrics = g2.getFontMetrics(font3);
            stringLength2 = SwingUtilities.computeStringWidth(metrics, this.card.victory.toUpperCase());
            x = this.vpX - stringLength2 / 2;
            g2 = this.setGraphicsHints(g2);
            g2.drawString(this.card.victory.toUpperCase(), x, this.vpY);
            if (this.includeBlurredBGVP) {
                this.drawUnderlay(bi, g2, type, 0, 0, this.vpBlurRadius, this.vpBlurDouble, this.expandVp);
            }
            g2.drawString(this.card.victory.toUpperCase(), x, this.vpY);
            g.drawImage((Image)bi, 0, 0, null);
            g2.dispose();
        }
        if (this.card.abilityText != null) {
            int y;
            BufferedImage bi3;
            block101: {
                ii = null;
                BufferedImage overlay = null;
                if (this.card.cardType != null && this.card.cardType.equals((Object)VillainCardType.VILLAIN)) {
                    ii = new ImageIcon(String.valueOf(this.templateFolder) + File.separator + "villain_normal" + File.separator + "back_text_overlay.png");
                    overlay = this.resizeImage(ii, this.cardWidth, this.cardHeight);
                } else if (this.card.cardType != null && this.card.cardType.equals((Object)VillainCardType.HENCHMEN)) {
                    ii = new ImageIcon(String.valueOf(this.templateFolder) + File.separator + "villain_henchmen" + File.separator + "back_text_overlay.png");
                    overlay = this.resizeImage(ii, this.cardWidth, this.cardHeight);
                } else if (this.card.cardType != null && (this.card.cardType.equals((Object)VillainCardType.MASTERMIND_TACTIC) || this.card.cardType.equals((Object)VillainCardType.MASTERMIND))) {
                    ii = new ImageIcon(String.valueOf(this.templateFolder) + File.separator + "villain_mastermind" + File.separator + "back_text_overlay.png");
                    overlay = this.resizeImage(ii, this.cardWidth, this.cardHeight);
                } else if (this.card.cardType != null && this.card.cardType.equals((Object)VillainCardType.BYSTANDER)) {
                    ii = new ImageIcon(String.valueOf(this.templateFolder) + File.separator + "bystander" + File.separator + "back_text_overlay.png");
                    overlay = this.resizeImage(ii, this.cardWidth, this.cardHeight);
                } else if (this.card.cardType != null && this.card.cardType.equals((Object)VillainCardType.WOUND)) {
                    ii = new ImageIcon(String.valueOf(this.templateFolder) + File.separator + "wound" + File.separator + "back_text_overlay.png");
                    overlay = this.resizeImage(ii, this.cardWidth, this.cardHeight);
                } else if (this.card.cardType != null && this.card.cardType.equals((Object)VillainCardType.BINDINGS)) {
                    ii = new ImageIcon(String.valueOf(this.templateFolder) + File.separator + "bindings" + File.separator + "back_text_overlay.png");
                    overlay = this.resizeImage(ii, this.cardWidth, this.cardHeight);
                }
                bi3 = new BufferedImage(this.cardWidth, this.cardHeight, 2);
                Graphics2D g23 = this.getGraphics(bi3);
                g23.setColor(this.textColor);
                y = 0;
                try {
                    Font font4 = Font.createFont(0, new File("Swiss 721 Light Condensed.ttf"));
                    font4 = font4.deriveFont((float)this.textSize);
                    g23.setFont(font4);
                    Font fontBold = Font.createFont(0, new File("Swiss 721 Black Condensed.ttf"));
                    fontBold = fontBold.deriveFont((float)this.textSize);
                    FontMetrics metrics3 = g23.getFontMetrics(font4);
                    g23 = this.setGraphicsHints(g23);
                    Integer x4 = this.textX;
                    y = this.textY;
                    int xOrigin = this.textX;
                    int xEnd = this.textX;
                    int yOrigin = this.textY;
                    int width = overlay.getWidth();
                    int height = overlay.getHeight();
                    boolean done = false;
                    int xx = 0;
                    while (xx < width) {
                        int yy = 0;
                        while (yy < height) {
                            Color originalColor = new Color(overlay.getRGB(xx, yy), true);
                            if (originalColor.getAlpha() > 0 && !done) {
                                x4 = xx;
                                y = yy + metrics3.getHeight();
                                xOrigin = xx;
                                yOrigin = yy;
                                done = true;
                            }
                            ++yy;
                        }
                        ++xx;
                    }
                    yOrigin += this.textStartOffset;
                    y += this.textStartOffset;
                    done = false;
                    int xFullEnd = xEnd;
                    int xx2 = width - 1;
                    while (xx2 >= 0) {
                        int yy = 0;
                        while (yy < height) {
                            Color originalColor = new Color(overlay.getRGB(xx2, yy), true);
                            if (originalColor.getAlpha() > 0 && !done) {
                                xFullEnd = xx2;
                                done = true;
                            }
                            ++yy;
                        }
                        --xx2;
                    }
                    List<WordDefinition> words = WordDefinition.getWordDefinitionList(this.card.abilityText);
                    for (WordDefinition wd : words) {
                        Color c;
                        Color color;
                        String s = wd.word;
                        String spaceChar = "";
                        if (wd.space) {
                            spaceChar = " ";
                        }
                        if (s.startsWith("<k>")) {
                            g23.setFont(fontBold);
                            metrics3 = g23.getFontMetrics(fontBold);
                            g23 = this.setGraphicsHints(g23);
                            s = s.replace("<k>", "");
                            continue;
                        }
                        if (s.startsWith("<r>")) {
                            g23.setFont(font4);
                            metrics3 = g23.getFontMetrics(font4);
                            g23 = this.setGraphicsHints(g23);
                            s = s.replace("<r>", "");
                            continue;
                        }
                        boolean gap = false;
                        if (s.equals("<g>")) {
                            gap = true;
                        }
                        Icon icon = this.isIcon(s);
                        if (gap) {
                            x4 = xOrigin;
                            int i = 0;
                            while (i < overlay.getWidth()) {
                                Color c2 = new Color(overlay.getRGB(i, y), true);
                                if (c2.getAlpha() > 0) {
                                    x4 = i;
                                    i = overlay.getWidth();
                                }
                                ++i;
                            }
                            y += g23.getFontMetrics(font4).getHeight() + this.getPercentage(g23.getFontMetrics(font4).getHeight(), this.textGapHeight);
                            continue;
                        }
                        if (icon == null) {
                            int stringLength3 = SwingUtilities.computeStringWidth(metrics3, s);
                            color = null;
                            try {
                                color = new Color(overlay.getRGB(x4 + 50, y), true);
                            }
                            catch (ArrayIndexOutOfBoundsException e) {
                                color = new Color(overlay.getRGB(0, 0), true);
                            }
                            if (color.getAlpha() == 0) {
                                if (x4 > xEnd && x4 <= xFullEnd || x4 > xFullEnd) {
                                    xEnd = x4;
                                }
                                x4 = xOrigin;
                                int i = 0;
                                while (i < overlay.getWidth()) {
                                    c = new Color(overlay.getRGB(i, y), true);
                                    if (c.getAlpha() > 0) {
                                        x4 = i;
                                        i = overlay.getWidth();
                                    }
                                    ++i;
                                }
                                y += g23.getFontMetrics(font4).getHeight() + this.getPercentage(g23.getFontMetrics(font4).getHeight(), this.textDefaultGapHeight);
                            }
                            g23.drawString(String.valueOf(s) + " ", (int)x4, y);
                            x4 = x4 + (stringLength3 + SwingUtilities.computeStringWidth(metrics3, spaceChar));
                            continue;
                        }
                        if (icon == null) continue;
                        BufferedImage i = this.getIconMaxHeight(icon, this.getPercentage(metrics3.getHeight(), this.textIconHeight));
                        color = new Color(overlay.getRGB(x4 + i.getWidth(), y + i.getHeight()), true);
                        if (color.getAlpha() == 0) {
                            if (x4 > xEnd && x4 <= xFullEnd || x4 > xFullEnd) {
                                xEnd = x4;
                            }
                            x4 = xOrigin;
                            int j = 0;
                            while (j < overlay.getWidth()) {
                                c = new Color(overlay.getRGB(j, y), true);
                                if (c.getAlpha() > 0) {
                                    x4 = j;
                                    j = overlay.getWidth();
                                }
                                ++j;
                            }
                            y += g23.getFontMetrics(font4).getHeight() + this.getPercentage(g23.getFontMetrics(font4).getHeight(), this.textDefaultGapHeight);
                        }
                        double offsetRatio = this.textIconHeight - 1.0;
                        int offset = this.getPercentage(i.getHeight(), offsetRatio);
                        int modifiedY = y - i.getHeight() + offset;
                        if (icon.isUnderlayMinimized()) {
                            this.drawUnderlay(i, g23, 2, x4, modifiedY, this.textIconBlurRadius, this.textIconBlurDouble, this.expandTextIcon);
                        }
                        g23.drawImage((Image)i, x4, modifiedY, null);
                        x4 = x4 + (i.getWidth() + SwingUtilities.computeStringWidth(metrics3, spaceChar));
                    }
                    if (this.card.cardType.equals((Object)VillainCardType.MASTERMIND) || this.card.cardType.equals((Object)VillainCardType.MASTERMIND_TACTIC)) {
                        if (xEnd < this.getPercentage(xFullEnd - xOrigin, 0.65)) {
                            xEnd = xFullEnd;
                        }
                        int padding = this.getPercentage(xEnd - xOrigin, this.rarePaddingRatio);
                        BufferedImage blurBG = this.createRareBacking(xOrigin - padding, (yOrigin += metrics3.getHeight() / 3) - padding, xEnd + padding, y + padding);
                        blurBG = this.makeTransparent(blurBG, 0.85);
                        blurBG = this.blurImage(blurBG, g23, this.rareBlurRadius);
                        int yOffsetValue = 0;
                        if (y < this.cardHeight - this.getPercentage(this.cardHeight, this.yOffsetRatio)) {
                            yOffsetValue = this.cardHeight - this.getPercentage(this.cardHeight, this.yOffsetRatio) - y;
                        }
                        g.drawImage((Image)blurBG, 0, yOffsetValue, null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (this.bwErr == null) break block101;
                    try {
                        this.bwErr.write(e.getMessage());
                        StackTraceElement[] stackTraceElementArray = e.getStackTrace();
                        int x4 = stackTraceElementArray.length;
                        int metrics3 = 0;
                        while (metrics3 < x4) {
                            StackTraceElement s = stackTraceElementArray[metrics3];
                            this.bwErr.write(s.toString());
                            ++metrics3;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            int yOffsetValue = 0;
            if (this.card.cardType != null && (this.card.cardType.equals((Object)VillainCardType.MASTERMIND_TACTIC) || this.card.cardType.equals((Object)VillainCardType.MASTERMIND)) && y < this.cardHeight - this.getPercentage(this.cardHeight, this.yOffsetRatio)) {
                yOffsetValue = this.cardHeight - this.getPercentage(this.cardHeight, this.yOffsetRatio) - y;
            }
            g.drawImage((Image)bi3, 0, yOffsetValue, null);
        }
        if (this.card.attack != null) {
            this.attackSize = 120;
            this.attackX = 650;
            this.expandAttack = 5;
            if (this.card.cardType.equals((Object)VillainCardType.HENCHMEN)) {
                ii = new ImageIcon(String.valueOf(this.templateFolder) + File.separator + "villain_henchmen" + File.separator + "back_attack.png");
                g.drawImage((Image)this.resizeImage(ii, this.cardWidth, this.cardHeight), 0, 0, null);
                this.attackSize -= 34;
                this.attackX += 16;
                this.expandAttack -= 2;
            } else {
                ii = new ImageIcon(String.valueOf(this.templateFolder) + File.separator + "villain_normal" + File.separator + "attr_attack.png");
                g.drawImage((Image)this.resizeImage(ii, this.cardWidth, this.cardHeight), 0, 0, null);
            }
            bi = new BufferedImage(this.cardWidth, this.cardHeight, 2);
            g2 = this.getGraphics(bi);
            g2.setColor(this.attackColor);
            Font font5 = null;
            try {
                font5 = Font.createFont(0, new File("Sylfaen.ttf"));
                font5 = font5.deriveFont((float)this.attackSize);
            }
            catch (Exception e) {
                e.printStackTrace();
                font5 = new Font("Sylfaen", 0, this.attackSize);
            }
            g2.setFont(font5);
            metrics = g2.getFontMetrics(font5);
            stringLength2 = SwingUtilities.computeStringWidth(metrics, this.card.attack.toUpperCase());
            x = this.attackX - stringLength2 / 2;
            g2 = this.setGraphicsHints(g2);
            g2.drawString(this.card.attack.toUpperCase(), x, this.attackY);
            if (this.includeBlurredBGAttack) {
                this.drawUnderlay(bi, g2, type, 0, 0, this.attackBlurRadius, this.attackBlurDouble, this.expandAttack);
            }
            g2.drawString(this.card.attack.toUpperCase(), x, this.attackY);
            g.drawImage((Image)bi, 0, 0, null);
            g2.dispose();
        }
        if (this.card.cost != null) {
            ii = new ImageIcon(String.valueOf(this.templateFolder) + File.separator + "hero_common" + File.separator + "back_cost.png");
            g.drawImage((Image)this.resizeImage(ii, this.cardWidth, this.cardHeight), 0, 0, null);
            bi2 = new BufferedImage(this.cardWidth, this.cardHeight, 2);
            Graphics2D g24 = this.getGraphics(bi2);
            g24.setColor(this.costColor);
            font = null;
            try {
                font = Font.createFont(0, new File("Sylfaen.ttf"));
                font = font.deriveFont((float)this.costSize);
            }
            catch (Exception e) {
                e.printStackTrace();
                font = new Font("Sylfaen", 0, this.costSize);
            }
            g24.setFont(font);
            FontMetrics metrics4 = g24.getFontMetrics(font);
            stringLength = SwingUtilities.computeStringWidth(metrics4, this.card.cost.toUpperCase());
            g24 = this.setGraphicsHints(g24);
            Integer offset = this.costOffsets.get("");
            int primitiveOffset = 0;
            char[] cArray = this.card.cost.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                offset = this.costOffsets.get("" + c);
                if (offset != null) {
                    primitiveOffset += offset.intValue();
                }
                ++n2;
            }
            int x5 = this.costX - stringLength / 2 + primitiveOffset;
            g24.drawString(this.card.cost.toUpperCase(), x5, this.costY);
            if (this.includeBlurredBGCost) {
                this.drawUnderlay(bi2, g24, type, 0, 0, this.costBlurRadius, this.costBlurDouble, this.expandCost);
            }
            g24.drawString(this.card.cost.toUpperCase(), x5, this.costY);
            bi2 = this.blurImage(bi2, g24, 2);
            g.drawImage((Image)bi2, 0, 0, null);
            g24.dispose();
        }
        if (this.exportImage) {
            this.exportImage(image);
        }
        g.dispose();
        return image;
    }

    public void exportImage(BufferedImage image) {
        try {
            if (this.exportToPNG) {
                File newFile = new File(String.valueOf(this.exportFolder) + File.separator + this.card.getCardName(this.exportFolder) + ".png");
                VillainMaker.exportToPNG(image, newFile);
            } else {
                File newFile = new File(String.valueOf(this.exportFolder) + File.separator + this.card.getCardName(this.exportFolder) + ".jpg");
                this.exportToJPEG(image, newFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void exportToJPEG(BufferedImage image, File newFile) throws Exception {
        System.out.println("Exporting: " + newFile.getName());
        BufferedImage bi = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        Graphics g = bi.getGraphics();
        g.drawImage(image, 0, 0, image.getWidth(), image.getHeight(), null);
        g.dispose();
        File dir = new File(this.exportFolder);
        dir.mkdirs();
        ImageIO.write((RenderedImage)bi, "jpeg", newFile);
    }

    public static void exportToPNG(BufferedImage image, File newFile) throws Exception {
        System.out.println("Exporting: " + newFile.getName());
        ImageIO.write((RenderedImage)image, "png", newFile);
    }

    public BufferedImage getIcon(Icon icon, int maxWidth, int maxHeight) {
        ImageIcon ii = new ImageIcon(icon.getImagePath());
        double r = 1.0;
        double rX = (double)maxWidth / (double)ii.getIconWidth();
        double rY = (double)maxHeight / (double)ii.getIconHeight();
        r = rY < rX ? rY : rX;
        return this.resizeImage(ii, r);
    }

    public BufferedImage getIconMaxHeight(Icon icon, int maxHeight) {
        ImageIcon ii = new ImageIcon(icon.getImagePath());
        double r = (double)maxHeight / (double)ii.getIconHeight();
        return this.resizeImage(ii, r);
    }

    public int getPercentageValue(int value, int max) {
        return (int)Math.round((double)value / (double)max * 100.0);
    }

    public int getPercentage(int size, double scale) {
        return (int)((double)size * scale);
    }

    public BufferedImage resizeImage(ImageIcon imageIcon, double scale) {
        int w = (int)((double)imageIcon.getIconWidth() * scale);
        int h = (int)((double)imageIcon.getIconHeight() * scale);
        int type = 2;
        BufferedImage image = new BufferedImage(w, h, type);
        Graphics g = image.getGraphics();
        g.drawImage(imageIcon.getImage(), 0, 0, w, h, 0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight(), null);
        g.dispose();
        return image;
    }

    public BufferedImage resizeImage(ImageIcon imageIcon, int width, int height) {
        int type = 2;
        BufferedImage image = new BufferedImage(width, height, type);
        Graphics g = image.getGraphics();
        g.drawImage(imageIcon.getImage(), 0, 0, width, height, 0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight(), null);
        g.dispose();
        return image;
    }

    public static ConvolveOp getGaussianBlurFilter(int radius, boolean horizontal) {
        if (radius < 1) {
            throw new IllegalArgumentException("Radius must be >= 1");
        }
        int size = radius * 2 + 1;
        float[] data = new float[size];
        float sigma = (float)radius / 3.0f;
        float twoSigmaSquare = 2.0f * sigma * sigma;
        float sigmaRoot = (float)Math.sqrt((double)twoSigmaSquare * Math.PI);
        float total = 0.0f;
        int i = -radius;
        while (i <= radius) {
            float distance = i * i;
            int index = i + radius;
            data[index] = (float)Math.exp(-distance / twoSigmaSquare) / sigmaRoot;
            total += data[index];
            ++i;
        }
        i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] / total;
        }
        Kernel kernel = null;
        kernel = horizontal ? new Kernel(size, 1, data) : new Kernel(1, size, data);
        return new ConvolveOp(kernel, 1, null);
    }

    private BufferedImage blackoutImage(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int xx = 0;
        while (xx < width) {
            int yy = 0;
            while (yy < height) {
                Color originalColor = new Color(image.getRGB(xx, yy), true);
                if (originalColor.getAlpha() > 0) {
                    image.setRGB(xx, yy, Color.BLACK.getRGB());
                }
                ++yy;
            }
            ++xx;
        }
        return image;
    }

    private void drawUnderlay(BufferedImage bi, Graphics2D g, int type, int x, int y, int blurRadius, boolean doubleBlur, int expandBlackout) {
        BufferedImage blackout = new BufferedImage(this.cardWidth, this.cardHeight, type);
        this.getGraphics(blackout).drawImage((Image)bi, x, y, null);
        blackout = this.blackoutImage(blackout);
        if (expandBlackout > 0) {
            blackout = this.expandBlackout(blackout, expandBlackout);
        }
        if (blurRadius > 0) {
            GaussianFilter op = new GaussianFilter(blurRadius);
            BufferedImage bi2 = op.filter(blackout, null);
            g.drawImage((Image)bi2, 0, 0, null);
            if (doubleBlur) {
                BufferedImage bi3 = op.filter(bi2, null);
                g.drawImage((Image)bi3, 0, 0, null);
            }
        } else {
            g.drawImage((Image)blackout, 0, 0, null);
        }
    }

    private BufferedImage blurImage(BufferedImage bi, Graphics g, int blurRadius) {
        if (blurRadius > 0) {
            GaussianFilter op = new GaussianFilter(blurRadius);
            BufferedImage bi2 = op.filter(bi, null);
            return bi2;
        }
        return bi;
    }

    private BufferedImage expandBlackout(BufferedImage image, int expandBlackout) {
        BufferedImage expand = new BufferedImage(this.cardWidth, this.cardHeight, 2);
        int width = image.getWidth();
        int height = image.getHeight();
        int xx = 0;
        while (xx < width) {
            int yy = 0;
            while (yy < height) {
                Color originalColor = new Color(image.getRGB(xx, yy), true);
                if (originalColor.getAlpha() > 0) {
                    int i = expandBlackout;
                    while (i > 0) {
                        try {
                            expand.setRGB(xx, yy - i, Color.BLACK.getRGB());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            expand.setRGB(xx, yy + i, Color.BLACK.getRGB());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            expand.setRGB(xx - i, yy, Color.BLACK.getRGB());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            expand.setRGB(xx + i, yy, Color.BLACK.getRGB());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (i == 1) {
                            try {
                                expand.setRGB(xx - i, yy - i, Color.BLACK.getRGB());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                expand.setRGB(xx - i, yy + i, Color.BLACK.getRGB());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                expand.setRGB(xx + i, yy - i, Color.BLACK.getRGB());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                expand.setRGB(xx + i, yy + i, Color.BLACK.getRGB());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        --i;
                    }
                }
                ++yy;
            }
            ++xx;
        }
        return expand;
    }

    private void listAllFonts() {
        Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        int i = 0;
        while (i < fonts.length) {
            System.out.println(fonts[i].getFontName());
            System.out.println(fonts[i].getName());
            System.out.println(fonts[i].getFamily());
            System.out.println(fonts[i].getAttributes().toString());
            System.out.println(fonts[i].getAvailableAttributes().toString());
            ++i;
        }
    }

    private Icon isIcon(String str) {
        block3: {
            try {
                if (str == null || str.startsWith("<") || str.endsWith(">")) break block3;
                return null;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        Icon i = Icon.valueOf(str.replace("<", "").replace(">", ""));
        return i;
    }

    private BufferedImage createRareBacking(int x, int y, int x2, int y2) {
        BufferedImage bi = new BufferedImage(this.cardWidth, this.cardHeight, 2);
        Graphics2D g2 = this.getGraphics(bi);
        g2.setColor(Color.WHITE);
        g2.fillRect(x, y, x2 - x, y2 - y);
        return bi;
    }

    private BufferedImage makeTransparent(BufferedImage bi, double percent) {
        int width = bi.getWidth();
        int height = bi.getHeight();
        int xx = 0;
        while (xx < width) {
            int yy = 0;
            while (yy < height) {
                Color originalColor = new Color(bi.getRGB(xx, yy), true);
                if (originalColor.getAlpha() > 0) {
                    int col = this.getPercentage(originalColor.getAlpha(), percent) << 24 | originalColor.getRed() << 16 | originalColor.getGreen() << 8 | originalColor.getBlue();
                    bi.setRGB(xx, yy, col);
                }
                ++yy;
            }
            ++xx;
        }
        return bi;
    }

    public BufferedImage resizeImagePS(BufferedImage bi) {
        double scale = 2.0;
        double xPadding = 0.043;
        double yPadding = 0.08;
        String exportType = "jpg";
        ImageIcon imageIcon = new ImageIcon(bi);
        int w = (int)((double)imageIcon.getIconWidth() * scale);
        int xPad = (int)((double)imageIcon.getIconWidth() * scale * xPadding);
        int fullW = w + xPad + xPad;
        int h = (int)((double)imageIcon.getIconHeight() * scale);
        int yPad = (int)((double)imageIcon.getIconHeight() * scale * yPadding);
        int fullH = h + yPad + yPad;
        int type = 2;
        if (exportType.equals("jpg")) {
            type = 1;
        }
        BufferedImage image = new BufferedImage(fullW, fullH, type);
        Graphics2D g = this.getGraphics(image);
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, fullW, fullH);
        g.drawImage(imageIcon.getImage(), xPad, yPad, w + xPad, h + yPad, 0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight(), null);
        g.dispose();
        return image;
    }

    private Graphics2D getGraphics(BufferedImage bi) {
        Graphics2D g2 = (Graphics2D)bi.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        return g2;
    }

    private Graphics2D setGraphicsHints(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        return g2;
    }
}

